unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,simprep,mdrep, biorep,ExtCtrls,printers, DBCtrls, DB,
  DBTables,quickrep, Spin,demopre, Labelrep,textlist;

type
  TTQuickReportDemo = class(TForm)
    PreviewBtn: TButton;
    PrintBtn: TButton;
    PrintDialogChk: TCheckBox;
    Bevel1: TBevel;
    ExitBtn: TButton;
    Image1: TImage;
    Shape1: TShape;
    Label2: TLabel;
    ReportCombo: TRadioGroup;
    OrientationCombo: TRadioGroup;
    Label1: TLabel;
    SpinEdit1: TSpinEdit;
    Label3: TLabel;
    PreviewCombo: TRadioGroup;
    Label4: TLabel;
    procedure ExitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PrintBtnClick(Sender: TObject);
    procedure PreviewBtnClick(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure ShowPreview;
    procedure PreviewComboClick(Sender: TObject);
  private
    { Private declarations }
    aReport : TQuickReport;
    procedure PickReport;
  public
    { Public declarations }
  end;

var
  TQuickReportDemo: TTQuickReportDemo;

implementation

{$R *.DFM}

procedure TTQuickReportDemo.ExitBtnClick(Sender: TObject);
begin
   Close;
end;

procedure TTQuickReportDemo.FormCreate(Sender: TObject);
begin
   ReportCombo.ItemIndex:=0;
   OrientationCombo.ItemIndex:=0;
   PreviewCombo.ItemIndex:=0;
end;

procedure TTQuickReportDemo.PickReport;
begin
   case ReportCombo.ItemIndex of
      0 : aReport:=SimpForm.SimpRep;
      1 : aReport:=Bioform.BioRep;
      2 : aReport:=mdform.mdRep;
      3 : aReport:=LabelForm.Rep;
      4 : aReport:=TextRep.Rep;
   end;
   aReport.DisplayPrintDialog:=PrintDialogChk.Checked;
   if OrientationCombo.ItemIndex=0 then
      aReport.Orientation:=poPortrait
   else
      aReport.Orientation:=poLandscape;
end;

procedure TTQuickReportDemo.PrintBtnClick(Sender: TObject);
{begin

procedure TfrmprevReports.spdbtnPrintClick(Sender: TObject);}
var
   ok : boolean;
   DestroyIt : Boolean;

begin
(*   ok := True;
   pickreport;
      areport.prepare;
   with TPrintDialog.Create(application) do try
      ok := Execute;
   finally
      free;
   end;

   if Ok then begin
      QRPrinter.print;
   end;
   qrprinter.cleanup;*)
   PickReport;
   aReport.Print;
end;

procedure TTQuickReportDemo.PreviewBtnClick(Sender: TObject);
begin
   PickReport;
   aReport.Preview;
end;

procedure TTQuickReportDemo.SpinEdit1Change(Sender: TObject);
begin
   QRPrinter.Thumbs:=SpinEdit1.Value;
end;

procedure TTQuickReportDemo.ShowPreview;
begin
   { Show our custom preview form }
   PrevForm.ShowModal;
end;

procedure TTQuickReportDemo.PreviewComboClick(Sender: TObject);
begin
   if PreviewCombo.ItemIndex=0 then
      QRPrinter.OnPreview:=nil                  { Select standard preview form }
   else
      QRPrinter.OnPreview:=ShowPreview;           { Select custom preview form }
end;


end.
